; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back Original (Copy Protected) - a.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Protection: Check error on t22s10 (simple ocean protection) - update "bounty bob" if found
; -------------------------------------------------------------------------------------------------------------- ;
; a: -> starter program           ($0100-$01ff) - auto start via stack
;       load pgm: col ........... ($d800-$dc00) - coloram
;       load pgm: scr ........... ($0400-$0800) - screen
;       load pgm: dat ........... ($0e00-$0e60) - loader
;       call pgm: --> dat
; 
; dat:  load pgm : bob-data ..... ($0d00-$0df0) - copy protection - check bad block at TT=22 SS=10
;       load pgm : bob-load ..... ($0845-$0cbf) - install fastload / exec fastload on next kernal LOAD call
;       call pgm : --> bob-load
;       load pgm : bounty-bob ... ($27c0-$cfff) - main program
;       call pgm : --> bounty bob  -> InitOnce ($2e64)
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ STACK                 ; autostart via stack
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes

C64CIA2                 include c64_cia2.asm        ; Complex Interface Adapter (CIA) #2 Registers  $dd00-$dd0f
C64VicII                include c64_vic.asm         ; Video Interface Chip (VIC-II) Registers       $d000-$d02e
C64Colors               include c64_color.asm       ; Colour RAM Address / Colours
C64Kernal               include c64_kernal.asm      ; Kernal Routines entry points                  $e000-$ffff
C64Memory               include c64_mem.asm         ; Standard Zeropage / Stack / Vector constants
; -------------------------------------------------------------------------------------------------------------- ;
; External Addresses
; -------------------------------------------------------------------------------------------------------------- ;
EntryPoint_DAT          = $0e00                     ; DAT module entry point
CartAutostartROM        = $8000                     ; 
; -------------------------------------------------------------------------------------------------------------- ;
Filler                  dc.w $6988                  ; needed to let A_Main start at STACK + $02 return address
; -------------------------------------------------------------------------------------------------------------- ;
; A_Main                Does    : Autostart: Starts at STACK + $02
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
A_Main                  subroutine                  ; 
                        lda #$03                    ; 
                        ora C2DDRA                  ; CIA2($DD02) Data Dir A
                        sta C2DDRA                  ; CIA2($DD02) Data Dir A
                        
                        lda CI2PRA                  ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        ora #CI2_VIC_MemBank_0      ; $03 = $0000-$3fff
                        sta CI2PRA                  ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        lda #[VIC_Video_0400 + VIC_CharS_1000] ; ...# .#..
                        sta VMCSB                   ; VIC($D018) VIC Chip Memory Control
                        
                        lda #[VIC_Screen_On + VIC_Rows25 + $03] ; ...# #.##
                        sta SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
                        lda #[VIC_Cols40]           ; ....#...
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #BLACK                  ; 
                        sta EXTCOL                  ; VIC($D020) Border Color
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        lda CartAutostartROM        ; 
                        inc CartAutostartROM        ; 
.Wait                   cmp CartAutostartROM        ; 
                        beq .Wait                   ; 
                        
.GetMessage_None        lda #$00                    ; turn off all kernal messages
.SetMessage_None        jsr SETMSG                  ; Kernel($FF90) Set Kernal message control flag ($FE18)
                        
                        ldy #$00                    ; 
.IniColorRam            lda #BLACK                  ; 
                        sta [COLORAM + $0000],y     ; ColorRAM ($D800-$DBFF)
                        sta [COLORAM + $0100],y     ; ColorRAM Page $01 - $D900($D800-$DBFF)
                        sta [COLORAM + $0200],y     ; ColorRAM Page $02 - $DA00($D800-$DBFF)
                        lda #BLACK                  ; 
                        sta [COLORAM + $0300],y     ; ColorRAM Page $03 - $DB00($D800-$DBFF)
                        
                        dey                         ; 
                        bne .IniColorRam            ; 
                        
.IniModuleAutoStart     ldy #TabModuleAutoStartLen  ; 
.SetModuleAutoStart     lda TabModuleAutoStart,y    ; 
                        sta CartAutostartROM,y      ; 
                        dey                         ; 
                        bpl .SetModuleAutoStart     ; 
A_MainX                 bmi LoadFiles               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabModuleAutoStart      dc.w A_Main                 ; 
                        dc.w A_Main                 ; 
                        text "CBM80"                ; 
TabModuleAutoStartLen   equ  [* - TabModuleAutoStart] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LoadFiles             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LoadFiles               subroutine                  ; 
                        lda #$04                    ; 
                        sta FileTabOffset           ; 
                        
.LoadNextFile           lda #$05                    ; logical file number
                        ldx #$08                    ; device number
.LoadToAdrOfDisk        ldy #$ff                    ; no secondary address used - load to disk address
                        jsr SETLFS                  ; Kernel($FFBA) Set logical file parameters ($FE00)
                        
                        ldy FileTabOffset           ; 
                        ldx FileNamesAddressLo,y    ; 
                        lda FileNamesLengths,y      ; number of characters in file name
                        pha                         ; 
                        lda FileNamesAddressHi,y    ; 
                        tay                         ; 
                        pla                         ; file name length
                        jsr SETNAM                  ; Kernel($FFBD) Set filename parameters ($FDF9)
                        
                        ldy FileTabOffset           ; 
                        ldx FileLoadAddressLo,y     ; 
                        lda FileLoadAddressHi,y     ; 
                        tay                         ; 
                        lda #$00                    ; flag: load
                        jsr LOAD                    ; Kernel($FFD5) Load from device (via $330 to $F49E)
                
.SetNextFile            dec FileTabOffset           ; 
                        dec FileTabOffset           ; 
                        bpl .LoadNextFile           ; COL SCR DAT
                        
LoadFilesX              jmp EntryPoint_DAT          ; goto MainDat
; -------------------------------------------------------------------------------------------------------------- ;
A_019e                  dc.b $af ; 
                        dc.b $01 ; 
A_01a0                  dc.b $aa ; 
                        dc.b $01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileLoadAddress         equ  *                      ; 
FileLoadAddressLo       equ  *                      ; 
FileLoadAddressHi       equ  [* + $01]              ; 
                        
FileLoadAddress_DAT     dc.w $0800                  ; not used
FileLoadAddress_SCR     dc.w $0400                  ; not used
FileLoadAddress_COL     dc.w $0005                  ; not used
                        
                        dc.w $0003                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileNames               equ  *                      ; 
FileNameDAT             text "dat"                  ; 
FileNameDATLen          equ  [* - FileNameDAT]      ; 

FileNameSCR             text "scr"                  ; 
FileNameSCRLen          equ  [* - FileNameSCR]      ; 

FileNameCOL             text "col"                  ; 
FileNameCOLLen          equ  [* - FileNameCOL]      ; 

                        text " "                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileTabOffset           dc.b $00                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileNamesLengths        equ  *                      ; 
                        dc.b FileNameDATLen         ; 
                        dc.b $01                    ; 
                        
                        dc.b FileNameSCRLen         ; 
                        dc.b $01                    ; 
                        
                        dc.b FileNameCOLLen         ; 
                        dc.b $01                    ; 
                        
                        dc.b $01                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileNamesAddress        equ  *                      ; 
FileNamesAddressLo      equ  *                      ; 
FileNamesAddressHi      equ  [* + $01]              ; 
                        dc.b <FileNameDAT           ; 
                        dc.b >FileNameDAT           ; 
                        
                        dc.b <FileNameSCR           ; 
                        dc.b >FileNameSCR           ; 
                        
                        dc.b <FileNameCOL           ; 
                        dc.b >FileNameCOL           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; On RTS of the 'LOAD "A",8,1 the BASIC interpreter picks the return address from the stack - here: A_MAIN
; -------------------------------------------------------------------------------------------------------------- ;
TabStackFillUp          equ  *              ; 
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
                        dc.w [A_Main - $01] ; return address
; -------------------------------------------------------------------------------------------------------------- ;
TabReturnAddress_Bas    dc.w $9701          ; 
; -------------------------------------------------------------------------------------------------------------- ;
